﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MapScroller : MonoBehaviour
{
    //NOTE: THIS SCRIPT IS DEBUG ONLY AND IS USED ONLY IN THE ASSET SCENE FOR EASE OF USE

    public Camera camera;
    public static GameObject PlayerObject;
    public GameObject DefaultPlayerObject;

    public float MinX;
    public float MinY;
    public float MaxX;
    public float MaxY;
    
    void Start()
    {
        PlayerObject = DefaultPlayerObject;
    }
    
    void Update()
    {
        Vector3 newPosition = new Vector3();
        newPosition = camera.transform.position;

        Vector3 playerRelativePosition = camera.transform.InverseTransformPoint(PlayerObject.transform.position);

        if (Mathf.Abs(playerRelativePosition.x) > 0.0f)
        {
            if (playerRelativePosition.x > 0.0f)
            {
                if (camera.transform.position.x <= MaxX - camera.aspect)
                {
                    newPosition.x += (playerRelativePosition.x * transform.lossyScale.x);
                }
            }

            else if (playerRelativePosition.x < 0.0f)
            {
                if (camera.transform.position.x >= MinX + camera.aspect)
                {
                    newPosition.x += (playerRelativePosition.x * transform.lossyScale.x);
                }
            }
        }

        if (Mathf.Abs(playerRelativePosition.y) > 0.0f)
        {
            if (playerRelativePosition.y > 0.0f)
            {
                //Up
                if (camera.transform.position.y <= MaxY)
                {
                    newPosition.y += (playerRelativePosition.y * transform.lossyScale.y);
                }
            }

            else if (playerRelativePosition.y < 0.0f)
            {
                //Down
                if (camera.transform.position.y - (camera.orthographicSize * 2.0f) >= MinY)
                {
                    newPosition.y += (playerRelativePosition.y * transform.lossyScale.y);
                }
            }
        }

        camera.transform.position = newPosition;
    }
}
